﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="NadgodzinyDoOdbioru.aspx.cs" Inherits="KOLKaP_WEB.KOLKaP.NadgodzinyDoOdbioru" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
  <title>Nadgodziny do odbioru</title>
  <link href="../Web.css?2" type="text/css" rel="stylesheet" />
  <link rel="stylesheet" href="../jquery/themes/ui-lightness/jquery-ui-1.9.2.custom.min.css" />
  <script src="../jquery/jquery-1.8.3.min.js" type="text/javascript"></script>
  <script src="../jquery/ui/jquery-ui-1.9.2.custom.min.js" type="text/javascript"></script>
  <script src="../jquery/ui/i18n/jquery.ui.datepicker-pl.js" type="text/javascript"></script>
  <script src="../jquery/jquery.blockUI.js" type="text/javascript"></script>
  <script type="text/javascript">
    $(function () {
      $("#btnOdswiez").button({ icons: { primary: 'ui-icon-refresh' } });
      $("#btnPowrot").button({ icons: { primary: 'ui-icon-arrowreturnthick-1-w' } });
      $("#btnWybierz").button({ icons: { primary: 'ui-icon-check' } });

      $('#tbDataOd').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });
      $('#tbDataDo').datepicker({ dateFormat: 'yy-mm-dd', changeMonth: true, changeYear: true, showAnim: '', yearRange: '1970:2060', showOn: 'button', buttonImage: '../img/calendar.gif', buttonImageOnly: true });

      $("#tbDataOd").datepicker("option", "dateFormat", 'yy-mm-dd');
      $("#tbDataDo").datepicker("option", "dateFormat", 'yy-mm-dd');

    });
  </script>
</head>
<body class="body">
  <form id="form1" runat="server">
    <div>
      <table class="Body" border="0" cellspacing="5px" cellpadding="0" width="100%">
        <tr>
          <td colspan="6">
            <asp:Label ID="lblOpis" runat="server" Font-Size="Medium" Font-Bold="True">Nadgodziny do odbioru</asp:Label>
          </td>
        </tr>
        <tr>
          <td colspan="6">
            <asp:Label ID="lblError" runat="server" EnableViewState="False"></asp:Label></td>
        </tr>
        <tr>
          <td style="width: 15%">
            <small>Nazwisko</small><br />
            <asp:TextBox ID="tbNazwisko" runat="server" Width="95%"></asp:TextBox></td>
          <td style="width: 15%">
            <small>Imię</small><br />
            <asp:TextBox ID="tbImie" runat="server" Width="95%"></asp:TextBox></td>
          <td style="width: 15%">
            <small>Pesel</small><br />
            <asp:TextBox ID="tbPesel" runat="server" Width="95%"></asp:TextBox>
          </td>
          <td style="width: 15%">
            <small>Nr kartoteki</small><br />
            <asp:TextBox ID="tbNrKartoteki" runat="server" Width="95%"></asp:TextBox>
          </td>
          <td style="width: 10%">
            <small>&nbsp;</small><br />
            <asp:LinkButton ID="btnOdswiez" runat="server" Width="90px" CssClass="Button" Text="Odśwież" OnClick="btnOdswiez_Click"></asp:LinkButton>
          </td>
          <td style="width: 30%; text-align: right"></td>
        </tr>
        <tr>
          <td colspan="2">
            <small>Jednostka</small><br />
            <asp:DropDownList ID="ddlJednostka" runat="server" Width="95%"></asp:DropDownList>
          </td>
          <td>
            <small>Data od</small><br />
            <asp:TextBox ID="tbDataOd" runat="server" Width="75%"></asp:TextBox>
          </td>
          <td>
            <small>Data do</small><br />
            <asp:TextBox ID="tbDataDo" runat="server" Width="75%"></asp:TextBox>
          </td>
          <td>
            <small>&nbsp;</small><br />
            <asp:CheckBox ID="cbSumarycznie" runat="server" Text="Sumarycznie" />
          </td>
          <td style="text-align: right">
            <div style="float: right">
              <small>&nbsp;</small><br />
              <asp:LinkButton ID="btnPowrot" runat="server" Width="90px" CssClass="Button" Text="Powrót" OnClick="btnPowrot_Click" Visible="false"></asp:LinkButton>
            </div>
            <div style="float: right">
              <small>&nbsp;</small><br />
              <asp:LinkButton ID="btnWybierz" runat="server" Width="90px" CssClass="Button" Text="Wybierz" Visible="false" OnClick="btnWybierz_Click"></asp:LinkButton>
            </div>
          </td>
        </tr>

      </table>
    </div>

    <div>
      <div id="divLiczbaWierszy" runat="server" class="Table" style="width: 100%; display: none; position: relative; height: 23px; background-color: White;">
        <div style="float: left; position: absolute; bottom: 2px;">
          <asp:Label ID="lblLiczbaWierszy" runat="server"></asp:Label>
        </div>
      </div>
      <asp:GridView ID="gvListy" runat="server" CssClass="aspGrid" Width="100%" AutoGenerateColumns="False" AllowSorting="True" DataSourceID="sdsListy" DataKeyNames="ID_PRACOWNIKA,NAZWISKO,IMIE,JEDNOSTKA,STANOWISKO,MINUTY,DATA_OD,ID_GODZINY,ODBIOR_CALY_DZIEN,RODZAJ_NAZWA" OnRowCommand="gvListy_RowCommand">
        <Columns>
          <asp:TemplateField ShowHeader="False">
            <ItemTemplate>
              <asp:CheckBox ID="cbWybierz" runat="server" />
            </ItemTemplate>
            <ControlStyle Width="20px" />
            <HeaderStyle Width="20px" />
            <ItemStyle VerticalAlign="Middle" Width="20px" />
          </asp:TemplateField>
          <asp:BoundField DataField="NAZWISKO" HeaderText="Nazwisko" SortExpression="NAZWISKO" />
          <asp:BoundField DataField="IMIE" HeaderText="Imię" SortExpression="IMIE" />
          <asp:BoundField DataField="NR_KARTOTEKI" HeaderText="Nr kartoteki" SortExpression="NR_KARTOTEKI" />
          <asp:BoundField DataField="JEDNOSTKA" HeaderText="Jednostka" SortExpression="JEDNOSTKA" />
          <asp:BoundField DataField="STANOWISKO" HeaderText="Stanowisko" SortExpression="STANOWISKO" />
          <asp:BoundField DataField="DATA_OD" HeaderText="Od" SortExpression="DATA_OD" DataFormatString="{0:yyyy-MM-dd HH:mm}" />
          <asp:BoundField DataField="DATA_DO" HeaderText="Do" SortExpression="DATA_DO" DataFormatString="{0:yyyy-MM-dd HH:mm}" />
          <asp:BoundField DataField="MINUTY_STR" HeaderText="Pozostało" SortExpression="MINUTY_STR" />
          <asp:BoundField DataField="ODBIOR_CALY_DZIEN" HeaderText="Odbiór dzień" SortExpression="ODBIOR_CALY_DZIEN" />
          <asp:BoundField DataField="ZAPLACONE_STR" HeaderText="Zapłacone" SortExpression="ZAPLACONE_STR" />
        </Columns>
        <PagerSettings Position="Top" />
        <RowStyle CssClass="TableItem" />
        <SelectedRowStyle CssClass="TableItemSelected" />
        <HeaderStyle CssClass="TableHeader" />
        <AlternatingRowStyle CssClass="TableItemAlt" />
      </asp:GridView>
      <asp:SqlDataSource ID="sdsListy" runat="server" ProviderName="System.Data.SqlClient" SelectCommand="NADGODZINY_DO_ODBIORU_LIST" SelectCommandType="StoredProcedure" ConnectionString="" CancelSelectOnNullParameter="False" OnSelected="sdsListy_Selected" OnSelecting="sdsListy_Selecting">
        <SelectParameters>
          <asp:SessionParameter Name="P_ID_FIRMY" SessionField="ID_FIRMY" />
          <asp:ControlParameter ControlID="tbNazwisko" Name="P_NAZWISKO" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="tbImie" Name="P_IMIE" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="tbNrKartoteki" Name="P_NR_KARTOTEKI" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="tbPesel" Name="P_PESEL" PropertyName="Text" Type="String" ConvertEmptyStringToNull="False" />
          <asp:ControlParameter ControlID="ddlJednostka" Name="P_ID_MPZ" PropertyName="SelectedValue" />
          <asp:ControlParameter ControlID="tbDataOd" Name="P_DATA_OD" PropertyName="Text" Type="DateTime" />
          <asp:ControlParameter ControlID="tbDataDo" Name="P_DATA_DO" PropertyName="Text" Type="DateTime" />
          <asp:Parameter Name="P_SUMARYCZNIE" DefaultValue="N"/>
          <asp:Parameter Name="P_WLASNE_NIE_ZEROWE" DefaultValue="N"/>
          <asp:Parameter Name="P_NADGODZINY_ODEJMIJ_XML" />
          <asp:Parameter Name="P_GODZINY_USUNIETE_XML" />
        </SelectParameters>
      </asp:SqlDataSource>
    </div>
  </form>
</body>
</html>

